<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2016/9/7
 * Time: 11:45
 */
include_once DIR_APPLICATION . "controller/chinadivision/config.php";
class ControllerChinadivisionOrder extends Controller {

    public function index(){

    }

    public function create(){
        if( empty($this->request->post["order_ids"]) ){
            die( json_encode( array("code"=>1, "info"=>"You have not select orders!", "data"=>null) ) );
        }
        $order_arr = explode(",", $this->request->post["order_ids"]);

        if ( !$this->_isSetApiKey() ){
            die( json_encode( array("code"=>-1, "info"=>"Please fill up your ChinaDivision Api Key before use the plugins", "data"=>null) ) );
        }

        foreach($order_arr as $order_id){
            $this->_doCreate($order_id);
        }

        echo json_encode( array("code"=>0, "info"=>"Success", "data"=>null) );

    }

    private function _doCreate($order_id){
        $this->load->model("chinadivision/order");
        $fields = "`order_id`,`telephone`,`shipping_firstname`,`shipping_lastname`,`telephone`,`shipping_address_1`,`shipping_address_2`,`shipping_city`,`shipping_postcode`,`shipping_country`,`shipping_method`,`shipping_zone`";
        $order_info = $this->model_chinadivision_order->getOrderById($order_id, $fields);

        if( empty($order_info) ){
            die( json_encode( array("code"=>1, "info"=>"Order have not Exist!", "data"=>null) ) );
        }

        $post_data = array(
            'order_id'      => $order_info['order_id'],
            'first_name'    => $order_info['shipping_firstname'],
            'last_name'     => $order_info['shipping_lastname'],
            'ship_address1' => $order_info['shipping_address_1'],
            'ship_address2' => $order_info['shipping_address_2'],
            'ship_city'     => $order_info['shipping_city'],
            'ship_state'    => $order_info['shipping_zone'],
            'ship_zip'      => $order_info['shipping_postcode'],
            'ship_country'  => $order_info['shipping_country'],
            'ship_phone'    => $order_info['telephone'],
            'shipping_method'=>$order_info['shipping_method'],
            'inspection'    => 1,
            'remark'        => "",
            'business_type' => 1,
            'plug_in_name'  => 'OPENCART',
        );

        $info = $this->model_chinadivision_order->getOrderProductByOrderId($order_id);
        $quantity = 0;
        foreach($info as &$product){
            $quantity += $product['quantity'];
            $product['product_url'] = HTTPS_CATALOG . "image/" . $product['product_url'];
        }

        $post_data['quantity'] = $quantity;
        $post_data['info'] = $info;

        $url = "http://api.chinadivision.com/order-create";
        $header = array(
            "Content-Type:application/x-www-form-urlencoded",
            "apikey:" . CHINADIVISION_API_KEY,
        );

        $this->_curlRequest($url, "POST", json_encode($post_data), $header);
    }


    private function _curlRequest ($url = "", $type = "GET", $post_data="", $header = array()) {
        if( !in_array($type, array("GET", "POST", "PUT", "DELETE")) ){
            return false;
        }

        switch($type) {
            case "GET":
                $ch = curl_init();
                if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                curl_setopt($ch, CURLOPT_HEADER, 0);    //不输出头域
                $output = curl_exec($ch);
                curl_close($ch);
                break;

            case "POST":
                $ch = curl_init();
                if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data );
                $output = curl_exec($ch);
                curl_close($ch);
                break;

            case "PUT":
                $ch = curl_init();
                if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $type);
                $output = curl_exec($ch);
                curl_close($ch);
                break;

            default:
                $output = false;
                break;
        }

        return $output;
    }

    private function _isSetApiKey(){
        if( defined("CHINADIVISION_API_KEY") ){
            return true;
        }

        return false;
    }

    public function addApiKey(){
        $this->response->setOutput( $this->load->view( "chinadivision/add_api_key.tpl" ) );
    }

    public function doAddApiKey(){
        if( empty($this->request->post['chinadivision_api_key']) || strlen($this->request->post['chinadivision_api_key']) != 32 ){
            die( json_encode( array( "code"=>1, "info"=>"Api Key not correct", "data"=>null ) ) );
        }

        $apikey = $this->request->post['chinadivision_api_key'];

        if( !$this->_isApiKeyExist($apikey) ){
            die( json_encode( array( "code"=>2, "info"=>"Api Key does not exist", "data"=>null ) ) );
        }

        $str = "\n\t" . "define('CHINADIVISION_API_KEY', '{$apikey}');";
        $file = DIR_APPLICATION . "controller/chinadivision/config.php";
        file_put_contents($file, $str, FILE_APPEND);

        echo json_encode( array( "code"=>0, "info"=>"Success", "data"=>null) );
    }

    private function _isApiKeyExist($apikey){
        if( empty($apikey) || strlen($apikey)!=32 ){
            return false;
        }

        $url = "http://www.chinadivision.com/index.php?route=apis/customer/apikeyExist";
        $res = $this->_curlRequest( $url, "POST", array('apikey'=>$apikey) );
        $res = json_decode($res, true);

        if( isset($res['code']) && $res['code']==0 ){
            return true;
        }

        return false;
    }
}