<?php
include_once DIR_APPLICATION . "controller/chinadivision/config.php";
class ControllerChinadivisionSku extends Controller{
    public function create(){
        $template = "chinadivision/sku.tpl";
        if( !$this->_isSetApiKey() ){
            $template = "chinadivision/add_api_key.tpl";
        }
        $this->response->setOutput( $this->load->view( $template ) );
    }

    public function doCreate(){
        $need_data = array("package_number", "tracking_number", "shipping_method", "quantity", "info", "remark");
        $miss_data = array_diff_key ( $need_data, array_keys($this->request->post) );
        if( !empty($miss_data) ){
            die ( json_encode( array( "code"=>1, "info"=>"Failed, missing necessary data!", "data"=>null ) ) );
        }

        if( !$this->_isSetApiKey() ){
            die ( json_encode( array( "code"=>-1, "info"=>"Please fill up your ChinaDivision Api Key before use the plugins!", "data"=>null ) ) );
        }

        $post_data = array(
            "package_number"  => $this->request->post["package_number"],
            "tracking_number" => $this->request->post["tracking_number"],
            "shipping_method" => $this->request->post["shipping_method"],
            "quantity" => $this->request->post["quantity"],
            "info"     => json_decode( html_entity_decode( $this->request->post["info"] ), true ),
            "remark"   => $this->request->post["remark"],
        );

        if( empty($post_data['info']) ){
            die ( json_encode( array( "code"=>2, "info"=>"SKU info can not empty!", "data"=>null ) ) );
        }


        $url = "http://api.chinadivision.com/sku-create";
        $header = array(
            "Content-Type:application/x-www-form-urlencoded",
            "apikey:" . CHINADIVISION_API_KEY,
        );

        $this->_curlRequest($url, "POST", json_encode($post_data), $header);

        echo json_encode( array( "code"=>0, "info"=>"Create SKU success", "data"=>null ) );
    }

    public function getSkuInfo(){
        if( empty($this->request->get['sku']) ){
            die ( json_encode( array("code"=>1, "info"=>"SKU is empty!", "data"=>null ) ) );
        }
        $sku = $this->request->get['sku'];

        $this->load->model("chinadivision/order");
        $sku_info = $this->model_chinadivision_order->getProductBySku($sku);

        if( empty($sku_info) ){
            die ( json_encode( array("code"=>2, "info"=>"SKU information not exists!", "data"=>null ) ) );
        }

        $sku_info['product_url'] = HTTPS_CATALOG . "image/" . $sku_info['product_url'];

        echo json_encode( array( "code"=>0, "info"=>"Bingo", "data"=>$sku_info ) );
        return;
    }

    private function _isSetApiKey(){
        if( defined("CHINADIVISION_API_KEY") ){
            return true;
        }

        return false;
    }

    private function _curlRequest ($url = "", $type = "GET", $post_data="", $header = array()) {
        if( !in_array($type, array("GET", "POST", "PUT", "DELETE")) ){
            return false;
        }

        switch($type) {
            case "GET":
                $ch = curl_init();
                if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                curl_setopt($ch, CURLOPT_HEADER, 0);    //不输出头域
                $output = curl_exec($ch);
                curl_close($ch);
                break;

            case "POST":
                $ch = curl_init();
                if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data );
                $output = curl_exec($ch);
                curl_close($ch);
                break;

            case "PUT":
                $ch = curl_init();
                if ( !empty($header) ) { curl_setopt($ch, CURLOPT_HTTPHEADER, $header); }
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 3);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $type);
                $output = curl_exec($ch);
                curl_close($ch);
                break;

            default:
                $output = false;
                break;
        }

        return $output;
    }
}