<?php

class ChinadivisionSku_Sku_SkuController extends Mage_Core_Controller_Front_Action {
    //生成创建SKU页面
	public function createAction() {
        $res = file_get_contents(MAGENTO_ROOT . '/app/code/local/ChinadivisionSku/Sku/controllers/Create-sku-page.php');
        echo $res;
    }

    //执行创建SKU操作
    public function do_createAction(){
        require_once MAGENTO_ROOT . "/app/code/local/ChinadivisionLib/Config/chinadivision-config.php";

        if (CHINADIVISION_API_KEY == "your apikey" || CHINADIVISION_API_KEY == "") {
            echo json_encode(array("code" => 1, "msg" => "apikey can not be empty.", "data" => null));
            return;
        }

        $info = json_decode($_POST['info'], true);

        $url = 'http://api.chinadivision.com/sku-create';
        $header = array(
            'Content-Type:application/x-www-form-urlencoded',
            'apikey:' . CHINADIVISION_API_KEY,
        );

        $post_data = array(
            'package_number' => $_POST['package_number'],
            'tracking_number' => $_POST['tracking_number'],
            'shipping_method' => $_POST['shipping_method'],
            'quantity' => (int) $_POST['quantity'],
            'inspection' => 1,
            'remark' => $_POST['remark'],
            'business_type' => 1,
            'info' => $info,
        );

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);

        $res = curl_exec($ch);
        echo $res;
    }

    public function get_sku_infoAction(){
        $return = array();
        $sku = $this->getRequest()->get('sku');
        if(empty($sku)){
            $return['mark'] = 1;
            $return['info'] = "sku is empty";
            echo json_encode($return);
            return;
        }

        $store_id = Mage::app()->getStore()->getId();
        $catalog_product_entity         = Mage::getSingleton('core/resource')->getTableName('catalog_product_entity');
        $catalog_product_index_price    = Mage::getSingleton('core/resource')->getTableName('catalog_product_index_price');
        $catalog_product_entity_varchar = Mage::getSingleton('core/resource')->getTableName('catalog_product_entity_varchar');

        $sql = <<<EOT
            SELECT e.sku,ip.price,ev.attribute_id,ev.value
            FROM {$catalog_product_entity} AS e
            LEFT JOIN {$catalog_product_index_price} AS ip ON e.entity_id=ip.entity_id
            LEFT JOIN {$catalog_product_entity_varchar} AS ev ON e.entity_id=ev.entity_id
            WHERE e.sku="{$sku}" AND ip.customer_group_id=0 AND ip.website_id={$store_id} AND (ev.attribute_id=71 OR (ev.attribute_id=98 AND ev.store_id={$store_id}));
EOT;
        $db_connect = Mage::getSingleton('core/resource')->getConnection('core_read');
        $res = $db_connect->fetchAll($sql);
        if(empty($res)){
            $return['mark'] = 2;
            $return['info'] = "can't find sku info";
            echo json_encode($return);
            return;
        }

        $return['mark']  = 0;
        $return['sku']   = $res[0]['sku'];
        $return['price'] = $res[0]['price'];
        foreach($res as $k=>$v){
            if(71 == $v['attribute_id']){
                $return['product_name'] = $v['value'];
            }else{
                $return['product_url'] = $v['value'];
            }
        }

        echo json_encode($return);
    }
}
