<?php

class ChinadivisionOrder_Order_OrderController extends Mage_Core_Controller_Front_Action {
    //创建订单入口
    public function createAction() {
        include MAGENTO_ROOT . "/app/code/local/ChinadivisionLib/Config/chinadivision-config.php";
        include MAGENTO_ROOT . "/app/code/local/ChinadivisionLib/Config/chinadivision-prefix.php";
        if( !isset($_REQUEST['order_ids']) || !(int)$_REQUEST['order_ids'] ){
            echo json_encode(array("stauts"=>1,"info"=>"Please select the order you need to create"));
            return;
        }
        $query_ids = $_REQUEST['order_ids'];
        $order_ids = explode(',', $query_ids);
        // print_r($order_ids);die;
        $success = array();
        $error = array();
        foreach($order_ids as $order_id){
            $res = $this->_do_create($order_id,CHINADIVISION_PREFIX,CHINADIVISION_API_KEY);
            if(strpos($res, '"code":0,') !== false){
                $success[] = $order_id;
            }else{
                $e = json_decode($res,true);
                if(!in_array($e['msg'],$error)){
                    $error[] = $e['msg'];
                }
            }
        }
        if(!empty($error)){
            echo json_encode(array('status'=>2,'info'=>$error));return;
        }
        if(empty($success)){
            $return['stauts'] = 2;
            $return['info'] = 'All the request order IDs have failed';
        }else{
            $success = implode(',', $success);
            $return['stauts'] = 0;
            $return['info'] = "All the request order IDs　: {$query_ids}\nRequest success order IDs : {$success}";
        }

        echo json_encode($return);
    }

    //执行创建订单
    private function _do_create($order_id,$prefix,$apikey){
        if ($apikey == "your apikey" || $apikey == "") {
            return json_encode(array("code" => 1, "msg" => "apikey can not be empty.", "data" => null));
        }
        $order_id = (int) $order_id;

        $db_connect = Mage::getSingleton('core/resource')->getConnection('core_read');

        $table_name = Mage::getSingleton('core/resource')->getTableName('sales_flat_order');
        $select = $db_connect->select()->from($table_name, array('customer_id','total_qty_ordered','shipping_address_id','customer_firstname','customer_lastname','shipping_method'))->where('entity_id=?', $order_id);
        $res = $db_connect->fetchRow($select);
        if(empty($res)){
            return;
        }
        
        $table_name = Mage::getSingleton('core/resource')->getTableName('sales_flat_order_address');
        $select = $db_connect->select()->from($table_name, array('region','postcode','street','city','telephone','country_id','company'))->where('entity_id=?', (int)$res['shipping_address_id']);
        $ship_res = $db_connect->fetchRow($select);
        $order_id_new = $order_id;
        if(!empty($prefix) && $prefix!=='your prefix'){
            $order_id_new = $prefix.$order_id;
        }
        $post_data = array(
            'order_id'          => $order_id_new,
            'inspection'        => 0,
            'business_type'     => 1,
            'first_name'        => $res['customer_firstname'],
            'last_name'         => $res['customer_lastname'],
            'quantity'          => (int)$res['total_qty_ordered'],
            'shipping_method'   => $res['shipping_method'],

            'ship_address1'     => $ship_res['street'],
            'ship_address2'     => '',  // 数据库中两个地址都存放在street字段中
            'ship_city'         => $ship_res['city'],
            'ship_state'        => $ship_res['region'],
            'ship_zip'          => $ship_res['postcode'],
            'ship_country'      => $ship_res['country_id'],
            'ship_phone'        => $ship_res['telephone'],
            'remark'            => '',
            'plug_in_name'      => 'MAGENTO',
        );

        unset($res);
        unset($ship_res);

        $table_name = Mage::getSingleton('core/resource')->getTableName('sales_flat_order_item');
        $select = $db_connect->select()->from($table_name, array('product_id','sku','name','qty_ordered'))->where('order_id=?', $order_id);
        $sku_res = $db_connect->fetchAll($select);
        if(empty($sku_res)){
            return;
        }

        $info = array();
        $table_name = Mage::getSingleton('core/resource')->getTableName('catalog_product_entity_varchar');
        foreach($sku_res as $k=>$v){
            //todo 最好与上一条SQL联表查询
            $select = $db_connect->select()->from($table_name, array('value'))->where('entity_id=? AND attribute_id=98 AND store_id=1', $v['product_id']);
            $url_res = $db_connect->fetchRow($select);

            $info[$k]['sku'] = $v['sku'];
            $info[$k]['product_name'] = $v['name'];
            $info[$k]['quantity'] = (int)$v['qty_ordered'];
            $info[$k]['product_url'] = $_SERVER['HTTP_HOST'] . '/index.php/' . $url_res['value'];
        }

        unset($sku_res);

        $post_data['info'] = $info;

        $url = 'http://api.chinadivision.com/order-create';
        $header = array(
            'Content-Type:application/x-www-form-urlencoded',
            'apikey:'. $apikey,
        );

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTPHEADER  , $header);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch , CURLOPT_URL , $url);
        $res = curl_exec($ch);

        return $res;
    }

}
